/* --------------------------------------------------------------
  BoilerplateApi.js 2019-06-07
  Gambio GmbH
  http://www.gambio.de
  Copyright (c) 2019 Gambio GmbH
  Released under the GNU General Public License (Version 2)
  [http://www.gnu.org/licenses/gpl-2.0.html]
  --------------------------------------------------------------*/


'use strict';

import Ajax from '../libs/Ajax';

export default {
	/**
	 * Get a list of all template boilerplates.
	 *
	 * The success callback will contain the boilerplate data.
	 *
	 * @return {jQuery.jqXHR}
	 */
	list() {
		const ajaxUrl = StyleEdit.Config.get('baseUrl') + '/api.php/templates/'
			+ encodeURIComponent(StyleEdit.Config.get('template')) + '/boilerplates?lang='
			+ StyleEdit.Config.get('languageCode');
		
		return Ajax.get(ajaxUrl, {
			lang: StyleEdit.Config.get('languageCode'),
			theme: StyleEdit.Config.get('theme') || undefined
		}, {dataType: 'json'});
	}
}
